/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import knightminer.inspirations.library.recipe.cauldron.CauldronRecipeMatchRecipe;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import slimeknights.mantle.util.RecipeMatch;

@ParametersAreNonnullByDefault
public class CauldronFluidRecipe
extends CauldronRecipeMatchRecipe {
    @Nullable
    protected ICauldronRecipe.CauldronState fluid;

    public CauldronFluidRecipe(RecipeMatch input, @Nullable Fluid fluid, ItemStack result, @Nullable Boolean boiling, int levels, SoundEvent sound) {
        super(input, result, boiling, levels, sound);
        this.fluid = fluid == null ? null : ICauldronRecipe.CauldronState.fluid(fluid);
    }

    public CauldronFluidRecipe(RecipeMatch input, @Nullable Fluid fluid, ItemStack result, @Nullable Boolean boiling, int levels) {
        this(input, fluid, result, boiling, levels, SoundEvents.field_187609_F);
    }

    public CauldronFluidRecipe(RecipeMatch input, @Nullable Fluid fluid, ItemStack result, @Nullable Boolean boiling, SoundEvent sound) {
        this(input, fluid, result, boiling, 1, sound);
    }

    public CauldronFluidRecipe(RecipeMatch input, @Nullable Fluid fluid, ItemStack result, @Nullable Boolean boiling) {
        this(input, fluid, result, boiling, SoundEvents.field_187609_F);
    }

    public CauldronFluidRecipe(RecipeMatch input, ItemStack result, @Nullable Boolean boiling) {
        this(input, null, result, boiling);
    }

    @Override
    protected boolean matches(ICauldronRecipe.CauldronState state) {
        return this.fluid == null ? state.isWater() : this.fluid.getFluid() == state.getFluid();
    }

    @Override
    public Object getInputState() {
        return this.fluid == null ? FluidRegistry.WATER : this.fluid.getFluid();
    }

    public String toString() {
        return String.format("CauldronFluidRecipe: %s from %s", this.getResult().toString(), this.fluid == null ? "water" : this.fluid.getFluid().getName());
    }
}

